% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_municipios.R
\name{padronizar_municipios}
\alias{padronizar_municipios}
\title{Padronizar municípios}
\usage{
padronizar_municipios(municipios)
}
\arguments{
\item{municipios}{Um vetor de caracteres ou números. Os municípios a serem
padronizados.}
}
\value{
Um vetor de caracteres com os municípios padronizados.
}
\description{
Padroniza um vetor de caracteres ou números representando municípios
brasileiros. Veja a seção \emph{Detalhes} para mais informações sobre a
padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item conversão para caracter, se o input for numérico;
\item remoção de espaços em branco antes e depois dos valores e remoção de
espaços em excesso entre palavras;
\item conversão de caracteres para caixa alta;
\item remoção de zeros à esquerda;
\item busca, a partir do código numérico, do nome completo de cada município;
\item caso a busca não tenha encontrado determinado valor, remoção de acentos e
caracteres não ASCII, correção de erros ortográficos frequentes e atualização
de nomes conforme listagem de municípios do IBGE de 2022.
}
}

\examples{
municipios <- c(
  "3304557", "003304557", " 3304557 ", "RIO DE JANEIRO", "rio de janeiro",
  "SÃO PAULO",
  "", NA
)
padronizar_municipios(municipios)

municipios <- c(3304557, NA)
padronizar_municipios(municipios)

municipios <- c("PARATI", "AUGUSTO SEVERO", "SAO VALERIO DA NATIVIDADE")
padronizar_municipios(municipios)

}
