% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_shards.R
\name{search_shards}
\alias{search_shards}
\title{Search shards}
\usage{
search_shards(
  conn,
  index = NULL,
  raw = FALSE,
  routing = NULL,
  preference = NULL,
  local = NULL,
  ...
)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{One or more indeces}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If \code{FALSE}, then
raw JSON}

\item{routing}{A character vector of routing values to take into account
when determining which shards a request would be executed against.}

\item{preference}{Controls a preference of which shard replicas to execute
the search request on. By default, the operation is randomized between the
shard replicas. See \link{preference} for a list of all acceptable
values.}

\item{local}{(logical) Whether to read the cluster state locally in order
to determine where shards are allocated instead of using the Master node's
cluster state.}

\item{...}{Curl args passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\description{
Search shards
}
\examples{
\dontrun{
# connection setup
(x <- connect())

search_shards(x, index = "plos")
search_shards(x, index = c("plos","gbif"))
search_shards(x, index = "plos", preference='_primary')
search_shards(x, index = "plos", preference='_shards:2')

# curl options
search_shards(x, index = "plos", verbose = TRUE)
}
}
\references{
\url{https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search-shards}
}
