% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{edge_find_ollama_models}
\alias{edge_find_ollama_models}
\title{Find and load Ollama models}
\usage{
edge_find_ollama_models(
  ollama_dir = NULL,
  test_compatibility = FALSE,
  max_size_gb = 10
)
}
\arguments{
\item{ollama_dir}{Optional path to Ollama models directory. If NULL, will auto-detect.}

\item{test_compatibility}{If TRUE, test if each model can be loaded successfully}

\item{max_size_gb}{Maximum model size in GB to consider (default: 10)}
}
\value{
List with ollama_path and discovered models information
}
\description{
Utility functions to discover and work with locally stored Ollama models.
Ollama stores models as SHA-256 named blobs which are GGUF files that can
be used directly with edgemodelr.
}
\examples{
\dontrun{
# Find Ollama models
ollama_info <- edge_find_ollama_models()

if (!is.null(ollama_info) && length(ollama_info$models) > 0) {
  # Use first compatible model
  model_path <- ollama_info$models[[1]]$path
  ctx <- edge_load_model(model_path)
  result <- edge_completion(ctx, "Hello", n_predict = 10)
  edge_free_model(ctx)
}
}
}
