% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_construction.R
\name{n_mat}
\alias{n_mat}
\title{Construct N matrix}
\usage{
n_mat(k, xd, normalized = TRUE, knot_idx = NULL)
}
\arguments{
\item{k}{Order for the discrete B-spline basis matrix. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{normalized}{Should the discrete B-spline basis vectors be normalized to
attain a maximum value of 1 over the design points? The default is \code{TRUE}.}

\item{knot_idx}{Vector of indices, a subset of \code{(k+1):(n-1)} where \code{n = length(xd)}, that indicates which design points should be used as knot
points for the discrete B-splines. Must be sorted in increasing order. The
default is \code{NULL}, which is taken to mean \code{(k+1):(n-1)} as in the
"canonical" discrete spline space (though in this case the returned N
matrix will be trivial: it will be the identity matrix). See details.}
}
\value{
Sparse matrix of dimension \code{length(xd)} by \code{length(knot_idx) + k + 1}.
}
\description{
Constructs the discrete B-spline basis matrix of a given order, with respect
to given design points and given knot points.
}
\details{
The discrete B-spline basis matrix of order \eqn{k}, with respect to
design points \eqn{x_1 < \ldots < x_n}, and knot set \eqn{T \subseteq
  x_{(k+1):(n-1)}} is denoted \eqn{N^k_T}. It has dimension \eqn{(|T|+k+1)
  \times n}, and its entries are given by:
\deqn{
  (N^k_T)_{ij} = \eta^k_j(x_i),
  }
where \eqn{\eta^k_1, \ldots, \eta^k_m} are discrete B-spline (DB-spline)
basis functions and \eqn{m = |T|+k+1}. As is suggested by their name, the
DB-spline functions are linearly independent and span the space of
discrete splines with knots at \eqn{T}. Each DB-spline \eqn{\eta^k_j} has a
key local support property: it is supported on an interval containing at
most \eqn{k+2} adjacent knots.

The functions \eqn{\eta^k_1, \ldots, \eta^k_m} are, in general, not available
in closed-form, and are defined by setting up and solving a sequence of
locally-defined linear systems. For any knot set \eqn{T}, computation of
the evaluations of all DB-splines at the design points can be done in
\eqn{O(nk^2)} operations; see Sections 7, 8.2, and 8.3 of Tibshirani (2020)
for details. The current function uses a sparse QR decomposition from the
\code{Eigen::SparseQR} module in C++ in order to solve the local linear systems.

When \eqn{T = x_{(k+1):(n-1)}}, the knot set corresponding to the "canonical"
discrete spline space (spanned by the falling factorial basis functions
\eqn{h^k_1, \ldots, h^k_n} whose evaluations make up \eqn{H^k_n}; see the
help file for \code{\link[=h_mat]{h_mat()}}), the DB-spline basis matrix, which we denote by
\eqn{N^k_n}, is trivial: it equals the \eqn{n \times n} identity matrix,
\eqn{N^k_n = I_n}. Therefore DB-splines are really only useful for knot
sets \eqn{T} that are proper subsets of \eqn{x_{(k+1):(n-1)}}.
Specification of the knot set \eqn{T} is done via the argument \code{knot_idx}.
}
\examples{
n_mat(2, 1:10, knot_idx = c(3, 5, 7))
n_mat(2, 1:10, knot_idx = c(4, 6, 8))
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Sections 7, 8.2, and 8.3.
}
\seealso{
\code{\link[=h_eval]{h_eval()}} for constructing evaluations of the discrete B-spline
basis at arbitrary query points.
}
