% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_construction.R
\name{h_mat}
\alias{h_mat}
\title{Construct H matrix}
\usage{
h_mat(k, xd, di_weighting = FALSE, col_idx = NULL)
}
\arguments{
\item{k}{Order for the falling factorial basis matrix. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{di_weighting}{Should "discrete integration weighting" be used?
Multiplication by such a weighted H gives discrete integrals at the design
points; see details for more information. The default is \code{FALSE}.}

\item{col_idx}{Vector of indices, a subset of \code{1:n} where \code{n = length(xd)},
that indicates which columns of the constructed matrix should be
returned. The default is \code{NULL}, which is taken to mean \code{1:n}.}
}
\value{
Sparse matrix of dimension \code{length(xd)} by \code{length(col_idx)}.
}
\description{
Constructs the falling factorial basis matrix of a given order, with respect
to given design points.
}
\details{
The falling factorial basis matrix of order \eqn{k}, with respect to
design points \eqn{x_1 < \ldots < x_n}, is denoted \eqn{H^k_n}. It has
dimension \eqn{n \times n}, and its entries are defined as:
\deqn{
  (H^k_n)_{ij} = h^k_j(x_i),
  }
where \eqn{h^k_1, \ldots, h^k_n} are the falling factorial basis functions,
defined as:
\deqn{
  \begin{aligned}
  h^k_j(x) &= \frac{1}{(j-1)!} \prod_{\ell=1}^{j-1}(x-x_\ell),
  \quad j=1,\ldots,k+1, \\
  h^k_j(x) &= \frac{1}{k!} \prod_{\ell=j-k}^{j-1} (x-x_\ell) \cdot
  1\{x > x_{j-1}\}, \quad j=k+2,\ldots,n.
  \end{aligned}
  }

The matrix \eqn{H^k_n} can also be constructed recursively, as follows. We
first define the \eqn{n \times n} lower triangular matrix of 1s:
\deqn{
  L_n =
  \left[\begin{array}{rrrr}
  1 & 0 & \ldots & 0 \\
  1 & 1 & \ldots & 0 \\
  \vdots & & & \\
  1 & 1 & \ldots & 1
  \end{array}\right],
  }
and for \eqn{k \geq 1}, define the \eqn{n \times n} extended diagonal
weight matrix \eqn{Z^k_n} to have first \eqn{k} diagonal entries equal to 1
and last \eqn{n-k} diagonal entries equal to \eqn{(x_{i+k} - x_i) / k},
\eqn{i = 1,\ldots,n-k}. The \eqn{k}th order falling factorial basis matrix
is then given by the recursion:
\deqn{
  \begin{aligned}
  H^0_n &= L_n, \\
  H^k_n &= H^{k-1}_n Z^k_n
  \left[\begin{array}{cc}
  I_k & 0 \\
  0 & L_{n-k}
  \end{array}\right],
  \quad \text{for $k \geq 1$},
  \end{aligned}
  }
where \eqn{I_k} denotes the \eqn{k \times k} identity matrix, and
\eqn{L_{n-k}} denotes the \eqn{(n-k) \times (n-k)} lower triangular matrix
of 1s.  For further details about this recursive representation, see
Sections 3.3 and 6.3 of Tibshirani (2020).

The option \code{di_weighting = TRUE} returns \eqn{H^k_n Z^{k+1}_n} where
\eqn{Z^{k+1}_n} is the \eqn{n \times n} diagonal matrix as defined above.
This is connected to discrete integration as explained in the help file for
\code{\link[=h_mat_mult]{h_mat_mult()}}. See also Section 3.3 of Tibshirani (2020) for more details.

Each basis function \eqn{h^k_j}, for \eqn{j \geq k+2}, has a single knot at
\eqn{x_{j-1}}. The falling factorial basis thus spans \eqn{k}th degree
piecewise polynomials---discrete splines, in fact---with knots in
\eqn{x_{(k+1):(n-1)}}. The dimension of this space is \eqn{n-k-1} (number
of knots) \eqn{+} \eqn{k+1} (polynomial dimension) \eqn{=} \eqn{n}. Setting
the argument \code{col_idx} appropriately allow one to form a basis matrix for a
discrete spline space corresponding to an arbitrary knot set \eqn{T
  \subseteq x_{(k+1):(n-1)}}. For more information, see Sections 4.1 and 8 of
Tibshirani (2020).

\strong{Note 1:} For computing the least squares projection onto a discrete spline
space defined by an arbitrary knot set \eqn{T \subseteq x_{(k+1):(n-1)}},
one should \strong{not} use the falling factorial basis, but instead use the
discrete natural spline basis from \code{\link[=n_mat]{n_mat()}}, as the latter has \strong{much}
better numerical properties in general. The help file for \code{\link[=dspline_solve]{dspline_solve()}}
gives more information.

\strong{Note 2:} For multiplication of a given vector by \eqn{H^k_n}, one should
\strong{not} form \eqn{H^k_n} with the current function and then carry out the
multiplication, but instead use \code{\link[=h_mat_mult]{h_mat_mult()}}, as the latter will be
\strong{much} more efficient (quadratic-time versus linear-time).
}
\examples{
h_mat(2, 1:10)
h_mat(2, 1:10 / 10)
h_mat(2, 1:10, col_idx = 4:7)
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Section 6.3.
}
\seealso{
\code{\link[=h_mat_mult]{h_mat_mult()}} for multiplying by the falling factorial basis
matrix and \code{\link[=h_eval]{h_eval()}} for constructing evaluations of the falling factorial
basis at arbitrary query points.
}
