% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.slice.R
\name{ds.slice}
\alias{ds.slice}
\title{Subset rows using their positions}
\usage{
ds.slice(
  df.name = NULL,
  tidy_expr = NULL,
  .by = NULL,
  .preserve = FALSE,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{List, provide either positive values to keep, or negative values to drop. The values
provided must be either all positive or all negative. Indices beyond the number of rows in the
input are silently ignored.}

\item{.by}{Optionally, a selection of columns to group by for just this operation, functioning as
an alternative to \code{dplyr::group_by}}

\item{.preserve}{Relevant when the .data input is grouped. If .preserve = FALSE (the default),
the grouping structure is recalculated based on the resulting data, otherwise the grouping is
kept as is.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. An object (typically a data frame or tibble)
with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::slice}.
}
\examples{
\dontrun{
ds.slice(
  df.name = "mtcars",
  expr = list(1:10),
  .by = "cyl",
  newobj = "sliced_df"
)
}
}
