% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{constant_effects_test}
\alias{constant_effects_test}
\title{Asymptotic sensitivity analysis for weak nulls with continuous exposures
assuming constant effects across matched sets.}
\usage{
constant_effects_test(
  Z,
  R,
  index,
  gamma = 0,
  theta = 0,
  X = NA,
  estimand_function = extract_OLS,
  gamma_star_vec = NULL
)
}
\arguments{
\item{Z}{A length N vector of  observed doses.}

\item{R}{A length N vector of observed outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{theta}{The value at which to test the weak null.}

\item{X}{A matrix with I rows and less than I columns that contains covariate
information.}

\item{estimand_function}{A function that takes in values z and r and outputs
a scalar; this function governs the causal estimand to estimate}

\item{gamma_star_vec}{that contains the maximum ratio of any two probabilities
of permutations for each matched set.}
}
\value{
A list containing the deviate, one-sided p-value,
observed value of the test statistic in each matched set,
and conservative standard deviation estimate.
}
\description{
Asymptotic sensitivity analysis for weak nulls with continuous exposures
assuming constant effects across matched sets.
}
\examples{
 # Load the data
data <- lead_bmd
# prepare data
threshold <- log(0.74675)
match_info = data |> dplyr::group_by(matched_sets) |>
dplyr::summarise(below = sum(log_lead < threshold) > 0, disc = var(log_lead) > 0,
above = sum(log_lead > threshold) > 0)
below_indices <- match_info$matched_sets[match_info$below]
disc_indices <- match_info$matched_sets[match_info$disc]
above_indices <- match_info$matched_sets[match_info$above]
# outcome analysis using the stochastic intervention statistic, weak null
below_nbp <- data |> dplyr::filter(matched_sets \%in\% below_indices & matched_sets
\%in\% disc_indices)
above_below <- below_nbp |> dplyr::filter(matched_sets \%in\% above_indices)
extract_below_threshold_vs_baseline_function <- function(z, r) {
  extract_below_threshold_vs_baseline(z, r, threshold)
}
# one-sided test that estimand defined by estimand_function is 0 at gamma = 0
result <- constant_effects_test(Z = above_below$log_lead,
R = above_below$lumbar_spine_bmd,
index = above_below$matched_sets, gamma = 0, theta = 0,
estimand_function = extract_below_threshold_vs_baseline_function)

}
