% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_view.R
\name{dockViewOutput}
\alias{dockViewOutput}
\alias{dock_view_output}
\alias{renderDockView}
\alias{render_dock_view}
\title{Shiny bindings for dock_view}
\usage{
dockViewOutput(outputId, width = "100\%", height = "400px")

dock_view_output(outputId, width = "100\%", height = "400px")

renderDockView(expr, env = parent.frame(), quoted = FALSE)

render_dock_view(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a dock_view}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
\code{dockViewOutput} and \code{dock_view_output}
return a Shiny output function that can be used in the UI definition.
\code{renderDockView} and \code{render_dock_view} return a
Shiny render function that can be used in the server definition to
render a \code{dock_view} element.
}
\description{
Output and render functions for using dock_view within Shiny
applications and interactive Rmd documents.
}
