#' @title Simpson's dominance index
#'
#' @description Computes Simpson's dominance index.
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Simpson's dominance index.
#'
#' @seealso \link{dominance}, \link{simpson_E}
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' simpson_D(Qesem_s$HU)
#'
#' @export
simpson_D <- function(x){
  x <- stats::na.omit(x)
  stopifnot(is.numeric(x))
  x <- ifelse(x==0, NA, x)
  x <- stats::na.omit(x)
  stopifnot(
    all(x >0),
    isTRUE(all.equal(x, round(x)))
  )
  p <- x/sum(x)
  return(sum(p^2))
}
