test_that("Variable type specified correctly.", {
  expect_equal(vtype(dst_bern(0.5)), "discrete")
  expect_equal(vtype(dst_beta(1, 1)), "continuous")
  expect_equal(vtype(dst_binom(size = 1, prob = 0.4)), "discrete")
  expect_equal(vtype(dst_cauchy(1, 1)), "continuous")
  expect_equal(vtype(dst_chisq(1)), "continuous")
  expect_equal(vtype(dst_degenerate(1)), "discrete")
  expect_equal(vtype(dst_exp(1)), "continuous")
  expect_equal(vtype(dst_f(1, 1)), "continuous")
  expect_equal(vtype(dst_gamma(1, 1)), "continuous")
  expect_equal(vtype(dst_geom(0.5)), "discrete")
  expect_equal(vtype(dst_gev(1, 1, 1)), "continuous")
  expect_equal(vtype(dst_gp(1, 1)), "continuous")
  expect_equal(vtype(dst_hyper(1, 1, 1)), "discrete")
  expect_equal(vtype(dst_lnorm(1, 1)), "continuous")
  expect_equal(vtype(dst_lp3(1, 1, 1)), "continuous")
  expect_equal(vtype(dst_nbinom(size = 1, prob = 0.4)), "discrete")
  expect_equal(vtype(dst_norm(1, 1)), "continuous")
  expect_true(is.na(vtype(dst_null())))
  expect_equal(vtype(dst_pearson3(1, 1, 1)), "continuous")
  expect_equal(vtype(dst_pois(1)), "discrete")
  expect_equal(vtype(dst_t(1)), "continuous")
  expect_equal(vtype(dst_unif(0, 1)), "continuous")
  expect_equal(vtype(dst_weibull(1, 1)), "continuous")
})

test_that("Variable type matches manual distribution input", {
  expect_identical(vtype(distribution(.vtype = "foofy")), "foofy")
  expect_identical(vtype(distribution(.vtype = "FoOFy")), "foofy")
  expect_identical(vtype(distribution()), "unknown")
  expect_identical(vtype(distribution()), vtype(distribution(.vtype = NULL)))
  expect_identical(vtype(distribution(.vtype = NA_character_)), NA_character_)
})
