% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_functions.R
\name{pick_data}
\alias{pick_data}
\title{Subsets EEG data by group, subject, sensor, time, experimental condition or epoch}
\usage{
pick_data(
  data,
  group_rg = NULL,
  subject_rg = NULL,
  sensor_rg = NULL,
  condition_rg = NULL,
  epoch_rg = NULL,
  time_rg = NULL
)
}
\arguments{
\item{data}{A data frame, tibble or database table with input data. Required columns depend on the further parameters: setting \code{subject_rg} requires \code{subject} column etc.}

\item{group_rg}{Optional vector of group identifiers to keep (character or numeric, matching \code{data$group}). If \code{NULL} (default), no filtering is applied based on group.}

\item{subject_rg}{Optional vector of subject identifiers to keep (character or numeric, matching \code{data$subject}). If \code{NULL} (default), no filtering is applied based on subject.}

\item{sensor_rg}{Optional vector of sensor identifiers to keep (character or numeric, matching \code{data$sensor}). If \code{NULL} (default), no filtering is applied based on sensor.}

\item{condition_rg}{Optional vector of experimental condition identifiers to keep (character or numeric, matching \code{data$condition}). If \code{NULL} (default), no filtering is applied based on condition.}

\item{epoch_rg}{Optional vector of epoch identifiers to keep (character or numeric, matching \code{data$epoch}). If \code{NULL} (default), no filtering is applied based on epoch.}

\item{time_rg}{Optional vector of time points to keep (numeric, matching \code{data$time}). If \code{NULL} (default), no filtering is applied based on time.}
}
\value{
An object of the same class as \code{data} with rows filtered by the provided criteria; columns are unchanged.
If all filters are \code{NULL}, the input is returned unmodified. If no rows match, the function ends with error message.
}
\description{
Filters an input dataset by optional constraints on group, subject, sensor, time, condition and epoch.
Filters are combined with logical AND, and exact value matching (\code{\%in\%}) is used.
}
\details{
All filters are combined conjunctively (AND). Matching uses membership (\code{\%in\%}) with case-sensitive comparison for character columns.
On database backends, very long *_rg vectors may not translate efficiently; consider pre-filtering or semi-joins.
}
\examples{
# Filtering epochs 1:5 and time points 1:10 for all subjects and sensor "E45"
data_subset <- pick_data(epochdata, sensor_rg = "E45",
 time_rg = 1:10, epoch_rg = 1:5)
head(data_subset)

\donttest{
# Setting parameters outside the input data range (there is no subject 6 in epochdata)
# results in an error message
try(
pick_data(epochdata, subject_rg = 6,
 time_rg = 1:10, epoch_rg = 1:5)
 )
}
}
\seealso{
\code{\link{compute_mean}}, \code{\link{baseline_correction}}, \code{\link{pick_region}}
}
