% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdm.R, R/lca.R
\name{residuals.fdm}
\alias{residuals.fdm}
\alias{fitted.fdm}
\alias{fitted.lca}
\alias{residuals.lca}
\title{Compute residuals and fitted values from functional demographic model or
Lee-Carter model}
\usage{
\method{residuals}{fdm}(object, ...)

\method{fitted}{fdm}(object, ...)

\method{fitted}{lca}(object, ...)

\method{residuals}{lca}(object, ...)
}
\arguments{
\item{object}{Output from \code{\link{fdm}} or \code{\link{lca}}.}

\item{...}{Other arguments.}
}
\value{
\code{residuals.fdm} and \code{residuals.lca} produce an object of
  class \dQuote{fmres} containing the residuals from the model.
  \code{fitted.fdm} and \code{fitted.lca} produce an object of class
  \dQuote{fts} containing the fitted values from the model.
}
\description{
After fitting a Lee-Carter model or functional demographic model, it is
useful to inspect the residuals or plot the fitted values. These functions
extract the relevant information from the fit object.
}
\examples{
fit1 <- lca(fr.mort)
plot(residuals(fit1))
plot(fitted(fit1))

}
\seealso{
\code{\link{fdm}}, \code{\link{lca}}, \code{\link{bms}}
}
\author{
Rob J Hyndman.
}
\keyword{models}
