% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_metadata.R
\name{check_metadata}
\alias{check_metadata}
\title{Check validity of a metadata statement}
\usage{
check_metadata(file = NULL, schema = NULL, quiet = FALSE)
}
\arguments{
\item{file}{An EML file to check Can be either local or a URL.}

\item{schema}{Either \code{NULL} (the default) to compare to the GBIF profile;
or a URL to a valid schema (passed internally to \link[xml2:read_xml]{xml2::read_xml}).}

\item{quiet}{(logical) Should messages be hidden? Defaults to \code{FALSE}.}
}
\value{
Invisibly returns a tibble showing parsed errors; or an empty
tibble if no errors are identified.
}
\description{
In the Darwin Core standard, metadata statements are mandatory and must be
provided in Ecological Metadata Language (EML) in a file called \code{eml.xml}. This
function applies a series of checks designed by GBIF to check the structure
of the specified xml document for consistency with the standard. Note,
however, that this function doesn't check the \emph{content} of those files,
meaning a file could be structurally sound and still be lacking critical
information.
}
\details{
This function uses local versions of \code{dc.xsd}, \code{eml-gbif-profile.xsd} and
\code{eml.xsd} downloaded
from \code{http://rs.gbif.org/schema/eml-gbif-profile/1.3/} on
2024-09-25.
}
\examples{
source_file <- system.file("extdata", 
                           "bionet_metadata.xml",
                           package = "delma")
check_metadata(source_file)
}
