% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.R
\name{fgdc_dict}
\alias{fgdc_dict}
\title{FGDC pattern labeling function/dictionary}
\usage{
fgdc_dict(clean = TRUE, nomatch = NULL, wrap = NULL)
}
\arguments{
\item{clean}{\code{logical}. Should the pattern names be cleaned? If \code{TRUE}
(default), the names will be cleaned to remove strings such as "(2nd
option)". If \code{FALSE}, the names will be verbatim from the FGDC standard.
Note that pattern names may not be unique when this is set to \code{TRUE}.}

\item{nomatch}{\code{character}. A string to label values that do not match any
name in the dictionary. When \code{NULL} (default), the values are kept as-is.}

\item{wrap}{\code{integer}. If not \code{NULL}, the pattern names will be wrapped to
the specified width (in characters) by insertting line breaks between words
using \code{\link[=strwrap]{strwrap()}} (words will not be broken). This can be useful for making
long names fit better in legends. If \code{NULL} (default), no wrapping is done.}
}
\value{
A \link[scales:label_dictionary]{labeling function} that takes
a vector \code{x} of pattern numbers and returns a character vector of
\code{length(x)} giving the corresponding pattern names. The function is
designed to be used with the \code{labels} argument of ggplot2 scales, such as
\code{\link[=scale_fill_geopattern]{scale_fill_geopattern()}} and \code{\link[ggpattern:scale_pattern_identity]{ggpattern::scale_pattern_type_identity()}}.
}
\description{
Generates a \link[scales:label_dictionary]{labeling function}/dictionary based
on the built-in \link{fgdc_names} dataset that can be used to retrieve the names
of patterns based on their pattern numbers/codes as defined in the \href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php}{FGDC Digital Cartographic Standard for Geologic Map Symbolization} by the \href{https://www.usgs.gov/}{U.S. Geological Survey} and the \href{https://ngmdb.usgs.gov/fgdc_gds/index.php}{Geologic Data Subcommittee (GDS)} of the \href{https://www.fgdc.gov/}{Federal Geographic Data Committee (FGDC)}. Like \link{fgdc_names}, only
patterns with names are included (i.e., patterns 601-733).
}
\examples{
library(ggplot2)
vals <- c("603", "626", "720", "733")
ggplot(mpg, aes(factor(cyl), fill = vals[factor(cyl)])) +
  geom_bar() +
  scale_fill_geopattern(name = NULL, labels = fgdc_dict())
}
\seealso{
FGDC patterns:
\code{\link{fgdc_names}},
\code{\link{geo_pattern}()},
\code{\link{grid.pattern_geo}()},
\code{\link{scale_fill_geopattern}()}
}
\concept{patterns}
