% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{Ponerinae_binary_range_table}
\alias{Ponerinae_binary_range_table}
\title{Dataset providing biogeographic range data for extant ponerine ants}
\format{
A data.frame with 1534 rows and 10 columns.
}
\usage{
data(Ponerinae_binary_range_table)
}
\description{
A data.frame of range location for the 1534 extant ponerine ant taxa (Ponerinae subfamily).

Source: Doré, M., Borowiec, M. L., Branstetter, M. G., Camacho, G. P., Fisher, B. L., Longino, J. T., Ward, P. S., Blaimer, B. B. (2025).
Evolutionary history of ponerine ants highlights how the timing of dispersal events shapes modern biodiversity. Nature Communications, 16, 8297.
\doi{10.1038/s41467-025-63709-3}
}
\details{
A data.frame of range locations covering the 1534 extant ponerine ant taxa (Ponerinae subfamily).
\itemize{
\item \verb{$Taxa} Character string. Names of ponerinae ant taxa.
\item \verb{$Afrotropics} Logical. Whether the range of the taxa extends to Afrotropics.
\item \verb{$Australasia} Logical. Whether the range of the taxa extends to Australasia.
\item \verb{$Indomalaya} Logical. Whether the range of the taxa extends to Indomalaya.
\item \verb{$Nearctic} Logical. Whether the range of the taxa extends to Nearctic.
\item \verb{$Neotropics} Logical. Whether the range of the taxa extends to Neotropics.
\item \verb{$Eastern_Palearctic} Logical. Whether the range of the taxa extends to Eastern Palearctic.
\item \verb{$Western_Palearctic} Logical. Whether the range of the taxa extends to Western Palearctic.
\item \verb{$Old_World} Logical. Whether the range of the taxa extends to the Old World: encompassing any bioregion among
Afrotropics, Australasia, Indomalaya, Eastern Palearctic, or Western Palearctic.
\item \verb{$New_World} Logical. Whether the range of the taxa extends to the New World: encompassing any bioregion among
Nearctic, or Neotropics.
}
}
\references{
Doré, M., Borowiec, M. L., Branstetter, M. G., Camacho, G. P., Fisher, B. L., Longino, J. T., Ward, P. S., Blaimer, B. B. (2025).
Evolutionary history of ponerine ants highlights how the timing of dispersal events shapes modern biodiversity. Nature Communications, 16, 8297.
\doi{10.1038/s41467-025-63709-3}
}
\keyword{datasets}
