% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_SVHT_coef.R
\name{sv_threshold}
\alias{sv_threshold}
\title{Singular value thresholding}
\usage{
sv_threshold(n, p, d)
}
\arguments{
\item{n}{number of samples}

\item{p}{number of features}

\item{d}{singular values}
}
\value{
Number of singular values to retain
}
\description{
Singular value thresholding evaluates the optimal number of singular values to retain
}
\examples{
# simulate data

n <- 500
p <- 5000
Y <- Rfast::matrnorm(n, p, seed = 1)

# SVD
dcmp <- svd(Y)

# how many components to retain
sv_threshold(n, p, dcmp$d)

# in this case the data has no structure, so no components are retained

}
\references{
Gavish, M., & Donoho, D. L. (2014). The optimal hard threshold for singular values is 4/sqrt(3). IEEE Transactions on Information Theory, 60(8), 5040-5053.
}
