% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{matchAfreq}
\alias{matchAfreq}
\title{Match Samples and Allele Frequencies}
\usage{
matchAfreq(dsmp, afreq, minfreq = 1e-04)
}
\arguments{
\item{dsmp}{a list with each element corresponding to one sample.}

\item{afreq}{a list of allele frequencies. Each element of the list
corresponds to a locus.}

\item{minfreq}{an allele frequency to assign to alleles that are present in
\code{dsmp} but not in \code{afreq}.}
}
\value{
A named list of length 2 containing updated and matching \code{dsmp}
and \code{afreq}.
}
\description{
Checks if the list containing sample data is conformable to provided
population allele frequencies and reformats it if needed.
}
\details{
The function reorders loci and alleles in \code{dsmp} to match those
in \code{afreq} and inserts alleles into \code{dsmp} if they are present in
\code{afreq} and not in \code{dsmp}; doesn't handle cases when alleles are
present in \code{dsmp} but not in \code{afreq}. Allele names are required
for this procedure.
}
\examples{
afile  <- system.file("extdata", "MozAfreq.csv", package = "dcifer")
afreq  <- readAfreq(afile, lvar = "locus", avar = "allele", fvar = "freq")
da_upd <- matchAfreq(dsmp, afreq, minfreq = 1e-3)
dsmp2  <- da_upd$dsmp
afreq2 <- da_upd$afreq

}
\seealso{
\code{\link{readDat}} and \code{\link{readAfreq}} for reading in and
reformating data.
}
