% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_checkbox.R
\name{tab_freq_checkbox}
\alias{tab_freq_checkbox}
\title{Frequency for Checkbox Fields.}
\usage{
tab_freq_checkbox(
  data,
  columns,
  sucess = "checked",
  labels = NULL,
  variable_name = NULL
)
}
\arguments{
\item{data}{dataframe object}

\item{columns}{character vector. Columns to count.}

\item{sucess}{character scalar. Category indicating the sucess. Defaults to "checked".}

\item{labels}{character vector.Label of each category. Defaults to NULL.}

\item{variable_name}{character scalar. Name of field in the form. Defaults to NULL.}
}
\value{
return a dataframe with \code{n} and \code{percent}
}
\description{
Each category (or option) is a variable in the dataframe, and we count the number of \code{sucess} in each column. The column \code{percent} is the ratio between this count by the observation number.
}
\details{
Missing values are ignored.
}
\examples{
data <- data.frame(
  x1 = c("checked", "checked", "unchecked"),
  x2 = c("checked", "unchecked", "checked")
)
tab_freq_checkbox(data, c("x1", "x2"))
}
