% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_cop_surf}
\alias{plot_cop_surf}
\title{Surface Plot or Heat Map of the Distribution or the Density of a Copula}
\usage{
plot_cop_surf(
  copula,
  type = "pdf",
  plot_type = "rgl",
  resolution = 50,
  n_gridlines = 11
)
}
\arguments{
\item{copula}{'\code{\linkS4class{cyl_copula}}' or a '\code{\link[copula:Copula-class]{Copula}}' object
from the package '\pkg{copula}'.}

\item{type}{\link[base]{character} string describing what is plotted,
either \code{"pdf"} or \code{"cdf"}.}

\item{plot_type}{\link[base]{character} string describing what type of plot
is produced. Available plot types are:
  \code{"rgl"}: surface plot,
  \code{"plotly"}: interactive surface plot, or
  \code{"ggplot"}: heatmap}

\item{resolution}{\link[base]{numeric} value. The density or distribution
will be calculated at \code{resolution^2} points.}

\item{n_gridlines}{\link[base]{numeric} value giving the number of grid
lines drawn in u and v direction.}
}
\value{
Depending on \code{plot_type}, a '\code{\link[ggplot2]{ggplot}}' object
is returned, or a '\pkg{plotly}' visualization or '\pkg{rgl}' plot is produced.
}
\description{
This function plots the distribution or the density of a copula. It can produce
a surface plot using either functions from the '\pkg{rgl}' or from the
'\pkg{plotly}' package, or it can produce a heat map using functions from
'\pkg{ggplot2}'.
}
\examples{
if(interactive()){
 plot_cop_surf(copula::frankCopula(2),
   type="pdf",
   plot_type="ggplot",
   resolution = 5
 )
 plot_cop_surf(copula::frankCopula(2),
   type="cdf",
   plot_type="ggplot",
   resolution = 5
 )

#opens a new window
  plot_cop_surf(cyl_quadsec(0.1),
    type="pdf",
    plot_type="rgl"
  )
  plot_cop_surf(cyl_quadsec(0.1),
    type="pdf",
    plot_type="rgl",
    n_gridlines = 60
  )

  plot_cop_surf(cyl_quadsec(0.1),
    type="pdf",
    plot_type="plotly",
    n_gridlines = 10,
    resolution = 10
  )
}

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{plot_cop_scat}()}, \code{\link{plot_track}()},
\code{\link{plot_joint_circ}()}, \code{\link{plot_joint_scat}()}.
}
