% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs-batch.R
\name{get_single_sample_records_by_dtxsid_batch}
\alias{get_single_sample_records_by_dtxsid_batch}
\title{Get Single Sample Records by DTXSID via batch}
\usage{
get_single_sample_records_by_dtxsid_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logicial indicating if some "progress report" should be
given.}
}
\value{
A list of data.frames containing single sample records data for each
input DTXSID.
}
\description{
Get Single Sample Records by DTXSID via batch
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Retrieve single sample records data for BPA and Caffeine
get_single_sample_records_by_dtxsid_batch(DTXSID = c('DTXSID0020232',
  'DTXSID7020182'))
\dontshow{\}) # examplesIf}
}
