% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_polynomial.R
\name{raw_polynomial_code}
\alias{raw_polynomial_code}
\title{Use raw polynomial coding}
\usage{
raw_polynomial_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Make raw polynomial contrast, rather than orthogonal ones. Normally you
would use orthogonal polynomials, so make sure this is what you want. Using
raw polynomials may increase the collinearity in your model, especially with
higher numbers of levels.
}
\details{
For n levels of factors where k in 1:n, generate a matrix with n-1
comparisons where each comparison looks for a polynomial trend of degree k,
where each polynomial may be correlated with the others. Normally you would
use orthogonal polynomials, see \code{\link[stats:contrast]{stats::contr.poly()}} and
\code{\link[=orth_polynomial_code]{orth_polynomial_code()}}
}
\examples{
mydf <- data.frame(
  grp = rep(c("a", "b", "c", "d"), each = 2000),
  val = c(
    rnorm(200, 2, 1),
    rnorm(200, 5, 1),
    rnorm(200, 7.5, 1),
    rnorm(200, 15, 1)
  )
) |>
  set_contrasts(grp ~ raw_polynomial_code)

stats::lm(val ~ grp, data = mydf)
}
