% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{data_for_table}
\alias{data_for_table}
\title{Prepare Population Data for Tabular Display}
\usage{
data_for_table(data, reg_code, harmonized = TRUE)
}
\arguments{
\item{data}{A data frame containing population data for a specific province
and year. Must include columns: \code{year}, \code{province_id}, \code{sex}, \code{age5}, and \code{pop}.}

\item{reg_code}{Integer or character. Province code used to retrieve
the province name.}

\item{harmonized}{Logical. If \code{TRUE} (default), province codes are treated as
harmonized; if \code{FALSE}, non-harmonized codes are used.}
}
\value{
A data frame in wide format with columns:
\itemize{
\item \code{province_id} — province identifier
\item \code{province} — province name
\item \code{year} — census year
\item \code{age5} — five-year age group label
\item \code{Male} — male population
\item \code{Female} — female population
\item \code{Male+Female} — total population
\item \code{sex_ratio} — ratio of males to females (per 100 females)
}
}
\description{
Prepares population data for tabular display (e.g., in reports or Shiny apps).
The function reshapes the data by sex, adds total population, and computes the
sex ratio, while also attaching province names and labels.
}
\details{
The function performs the following steps:
\itemize{
\item Adds the province name using \code{\link[=reg_name]{reg_name()}}.
\item Relabels \code{sex} and \code{age5} using reference tables in \code{ref_label}.
\item Reshapes data into wide format with separate columns for \code{Male} and \code{Female}.
\item Adds a \code{Male+Female} total population column.
\item Computes the sex ratio (\code{Male/Female * 100}).
}
}
\examples{
\dontrun{
data_idn <- pop_data_by_year(load_pop_data(), 2020) |>
  pop_data_by_reg(0) #Indonesia
tab <- data_for_table(data_idn, reg_code = 0, harmonized = TRUE)
head(tab)
}

}
\seealso{
\code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_year]{pop_data_by_year()}}, \code{\link[=get_code_label]{get_code_label()}}
}
