% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-graphml.R
\name{to_graphml}
\alias{to_graphml}
\title{Export caugi Graph to GraphML Format}
\usage{
to_graphml(x)
}
\arguments{
\item{x}{A \code{caugi} object.}
}
\value{
A \code{caugi_graphml} object containing the GraphML representation.
}
\description{
Converts a caugi graph to the GraphML XML format as a string.
GraphML is widely supported by graph analysis tools and libraries.
}
\details{
The GraphML export includes:
\itemize{
\item Node IDs and labels
\item Edge types stored as a custom \code{edge_type} attribute
\item Graph class stored as a graph-level attribute
}

Edge types are encoded using the caugi DSL operators (e.g., "-->", "<->").
This allows for perfect round-trip conversion back to caugi.
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

# Get GraphML string
graphml <- to_graphml(cg)
cat(graphml@content)

# Write to file
\dontrun{
write_graphml(cg, "graph.graphml")
}

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
