% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_ug}
\alias{is_ug}
\title{Is the \code{caugi} graph an UG?}
\usage{
is_ug(cg, force_check = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{force_check}{Logical; if \code{TRUE}, the function will test if the graph is
an UG, if \code{FALSE} (default), it will look at the graph class and match
it, if possible.}
}
\value{
A logical value indicating whether the graph is an UG.
}
\description{
Checks if the given \code{caugi} graph is an undirected graph (UG).
}
\examples{
cg_ug_class <- caugi(
  A \%---\% B,
  class = "UG"
)
is_ug(cg_ug_class) # TRUE
cg_not_ug <- caugi(
  A \%-->\% B,
  class = "DAG"
)
is_ug(cg_not_ug) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
