% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sme_emissions.R
\name{plot_sme_emissions}
\alias{plot_sme_emissions}
\title{Plot SME Emissions}
\usage{
plot_sme_emissions(
  scope1_emissions,
  scope2_emissions,
  scope3_emissions,
  company_name = NULL
)
}
\arguments{
\item{scope1_emissions}{Value for total Scope 1 emissions (numeric).}

\item{scope2_emissions}{Value for total Scope 2 emissions (numeric).}

\item{scope3_emissions}{Value for total Scope 3 emissions (numeric).}

\item{company_name}{Optional company name to include in the chart title (character string).}
}
\value{
A ggplot2 donut chart showing predicted emissions for each scope.
}
\description{
Plot a donut chart of Scope 1,2 and 3 emissions
}
\examples{
scope_1 = sme_scope1(85, 12000000)
scope_2 = sme_scope2(85, 12000000)
scope_3 = sme_scope3(85, 12000000)
plot_sme_emissions(
scope1_emissions = scope_1$`Predicted Emissions (tCO2e)`,
scope2_emissions = scope_2$`Predicted Emissions (tCO2e)`,
scope3_emissions = scope_3[scope_3$Category == "Total", "Predicted Emissions (tCO2e)"][[1]],
company_name = "Carbon Predict LTD")
}
