% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_coachingangebote.R
\name{coachingangebote_search}
\alias{coachingangebote_search}
\title{Search coaching offers}
\usage{
coachingangebote_search(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with coaching offers.

Includes \code{gueltig_von_time}, \code{gueltig_bis_time}, and \code{aktualisierungsdatum_time} as POSIXct in Europe/Berlin.
}
\description{
Search coaching offers
}
\details{
The Coachingangebote API provides coaching and activation offers from the
Bundesagentur fuer Arbeit. Authentication can be done via OAuth2 client
credentials or by sending the public client id as \code{X-API-Key} (clientId
\verb{ee971dcb-96fa-47b3-b2be-00863e4fc88b}). Official docs:
https://bundesapi.github.io/coachingangebote-api/.

\strong{Recommended:} Configure OAuth2 via \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} with type \code{"oauth2"}.
If you provide a client secret, it fetches an OAuth token; otherwise it falls
back to sending the client ID as \code{X-API-Key}.
}
\examples{
\dontrun{
# Recommended: OAuth2 configuration
Sys.setenv(
  COACHINGANGEBOTE_API_KEY = "ee971dcb-96fa-47b3-b2be-00863e4fc88b",
  COACHINGANGEBOTE_CLIENT_SECRET = "<client-secret>"
)
bunddev_auth_set("coachingangebote",
  type = "oauth2",
  oauth_url = "https://rest.arbeitsagentur.de/oauth/gettoken_cc",
  env_var = "COACHINGANGEBOTE_API_KEY",
  oauth_secret_env = "COACHINGANGEBOTE_CLIENT_SECRET",
  oauth_default_id = "ee971dcb-96fa-47b3-b2be-00863e4fc88b")
coachingangebote_search(params = list(mz = "SA 01"))
}

}
\seealso{
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure authentication.
}
