% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_external.R
\name{bs_new_embed_external}
\alias{bs_new_embed_external}
\title{Embed external media in a post}
\usage{
bs_new_embed_external(
  uri,
  title,
  description,
  thumb,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{uri}{a link to embed}

\item{title}{the title for the link}

\item{description}{a description of the link}

\item{thumb}{Optional. A thumbnail for the link}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a list representation of an external embed
}
\description{
Embeds are not designed as standalone records, but rather as part of a post.
This will create a list representation of an external embed.
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/embed/external.json}{embed/external.json (2024-12-05)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-05)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_new_embed_external(
  uri = 'https://christophertkenny.com/bskyr/',
  title = 'Interact with Bluesky Social',
  description = 'An R package for using Bluesky Social'
)

bs_new_embed_external(
  uri = 'https://christophertkenny.com/bskyr/'
)
\dontshow{\}) # examplesIf}
}
\concept{embed}
