\name{compare.tables}
\alias{compare.tables}
\title{Contingency tables comparing true labels to fitted clusterings}
\description{
Given the output of \code{\link{compare.clusters}} and a vector of true class labels,
prints confusion tables for: (i) hard \eqn{k}-means labels, (ii) the bootstrap augmented \eqn{k}-means
MAP out-of-bag labels, and (optionally) (iii) fuzzy \eqn{c}-means hard labels.
}

\usage{
compare.tables(full.res = NULL, true.labs = NULL, verbose = TRUE)
}

\arguments{
  \item{full.res}{A list returned by \code{\link{compare.clusters}}, containing components \code{km}, \code{bkm}, 
  and \code{fkm} (the latter only if argument \code{what = "all"} in function \code{compare.clusters}).}
  \item{true.labs}{A vector of true class labels.}
  \item{verbose}{Logical; if \code{TRUE}, prints the contingency tables to the console. Default is \code{TRUE}.
  }
}

\details{
For \eqn{k}-means, hard labels are taken from \code{full.res$km$cluster}. For bootstrap \eqn{k}-means, labels
are taken from \code{full.res$bkm$clusters}. If \code{full.res$what == "all"} results are also
taken from \code{full.res$fkm$clus}, which are the hard cluster assignments from the fuzzy \eqn{c}-means
algorithm.

The function prints two or three contingency tables to the console, with three presented if
\code{\link{compare.clusters}} has argument \code{what = "all"}, and two otherwise.
}

\value{
A list with components:
  \item{kmeans}{A contingency table comparing true labels to \eqn{k}-means cluster assignments.}
  \item{bootkmeans}{A contingency table comparing true labels to boot\eqn{k}means cluster assignments.}
  \item{fuzzcmeans}{(Optional) A contingency table comparing true labels to fuzzy \eqn{c}-means cluster assignments,
  included only if \code{full.res$what == "all"}.}

If \code{verbose = TRUE}, the tables are also printed to the console.
}

\references{
Ghashti, J.S., Andrews, J.L., Thompson, J.R.J., Epp, J. and H.S. Kochar (2025). A bootstrap augmented \eqn{k}-means algorithm for fuzzy partitions. Submitted.

Bezdek, J.C. (1981). \emph{Pattern recognition with fuzzy objective function algorithms}. New York: Plenum.

Hartigan, J.A. and M.A. Wong (1979). Algorithm AS 136: A K-means clustering algorithm. \emph{Applied Statistics, 28}, 100–108.

Ferraro, M.B., Giordani P. and A. Serafini (2019). fclust: An R Package for Fuzzy Clustering, \emph{The R Journal, 11}.
}

\seealso{
\code{\link{boot.kmeans}}, \code{\link{compare.clusters}}, \code{\link{bootk.hardsoftvis}}, \code{\link[stats]{kmeans}}, \code{\link[fclust]{FKM}}
}

\examples{
set.seed(1)
x <- as.matrix(iris[, -5])

# fit three methods (kmeans, bootstrap kmeans, fuzzy \eqn{c}-means)
res <- compare.clusters(x, groups = 3, nstart = 10, what = "all")

# compare contigency tables
compare.tables(res, true.labs = iris$Species)
}

\keyword{clustering}
\keyword{multivariate}
\keyword{nonparametric}
\keyword{bootstrap}
\keyword{kmeans}
\keyword{fuzzy}


