all_jacobians <- function(sim) {
  costs <- costs(sim)
  Y <- flows(sim)
  X <- rowSums(Y)
  alpha <- return_to_scale(sim)
  beta <- inverse_cost(sim)
  Z <- attractiveness(sim)
  exp_costs <- exp(-beta * costs)

  Z_alpha <- Z**alpha
  Y_norm <- exp_costs %*% Z_alpha
  Z_alphaminus <- alpha * (Z**(alpha - 1))
  ZeC_minus <- sweep(exp_costs, 2, Z_alphaminus, "*")
  ZeC_minus_norm <- sweep(ZeC_minus, 1, Y_norm[, 1], "/")
  base_jac <- -crossprod(Y, ZeC_minus_norm)
  diag_fix <- (X %*% ZeC_minus_norm)[1, ]
  diag(base_jac) <- diag(base_jac) + diag_fix

  Z_jac <- diag(1, length(Z)) - base_jac

  log_Z <- log(Z)
  XZeC <- outer(X, Z_alpha) * exp_costs
  XZeCLogZ <- sweep(XZeC, 2, log_Z, "*")
  ZeCLogZ_sum <- rowSums(sweep(exp_costs, 2, Z_alpha * log_Z, "*"))
  XZeCLogZ_norm <- sweep(XZeCLogZ, 1, Y_norm, "/")
  pre_alpha <- XZeCLogZ_norm - sweep(Y, 1, ZeCLogZ_sum / Y_norm, "*")
  j_alpha <- -colSums(pre_alpha)
  cZeC <- -XZeC * costs
  cZeC_norm <- sweep(cZeC, 1, Y_norm, "/")
  cZeC_sum <- rowSums(-sweep(exp_costs, 2, Z_alpha, "*") * costs)
  pre_beta <- cZeC_norm - sweep(Y, 1, cZeC_sum / Y_norm, "*")
  j_beta <- -colSums(pre_beta)
  ab_jac <- cbind(j_alpha, j_beta)
  list(fp_jac = base_jac, Z_jac = Z_jac, ab_jac = ab_jac)
}

fixed_point_stability <- function(the_jac) {
  1 - max(Mod(eigen(the_jac, only.values = TRUE)$value))
}

inverse_jacobian <- function(all_jac) {
  -solve(all_jac$Z_jac, all_jac$ab_jac)
}

solution_stability <- function(all_jac) {
  norm(inverse_jacobian(all_jac), "F")
}
