% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-block.R
\name{new_ggplot_block}
\alias{new_ggplot_block}
\title{Universal ggplot block with selectable visualization types}
\usage{
new_ggplot_block(
  type = "point",
  x = character(),
  y = character(),
  color = character(),
  fill = character(),
  size = character(),
  shape = character(),
  linetype = character(),
  group = character(),
  alpha = character(),
  density_alpha = 0.8,
  position = "stack",
  bins = 30,
  donut = FALSE,
  ...
)
}
\arguments{
\item{type}{Initial chart type (default "point"). Options: "point", "bar",
"line", "boxplot", "violin", "density", "area", "histogram", "pie"}

\item{x}{Column for x-axis}

\item{y}{Column for y-axis}

\item{color}{Column for color aesthetic}

\item{fill}{Column for fill aesthetic}

\item{size}{Column for size aesthetic}

\item{shape}{Column for shape aesthetic}

\item{linetype}{Column for linetype aesthetic}

\item{group}{Column for group aesthetic}

\item{alpha}{Column for alpha aesthetic (variable transparency)}

\item{density_alpha}{Fixed alpha value for density plots (default 0.8)}

\item{position}{Position adjustment for certain geoms}

\item{bins}{Number of bins for histogram}

\item{donut}{Whether to create donut chart when type is "pie" (default FALSE)}

\item{...}{Forwarded to \code{\link[blockr.core]{new_plot_block}}}
}
\value{
A plot block object of class \code{ggplot_block}.
}
\description{
A flexible block that allows users to select from various ggplot2 geoms
and dynamically shows relevant aesthetics for the selected visualization.
}
\examples{
# Create a scatter plot block
new_ggplot_block(type = "point", x = "mpg", y = "hp")

# Create a bar chart block
new_ggplot_block(type = "bar", x = "cyl")

if (interactive()) {
  library(blockr.core)
  serve(new_ggplot_block(), list(data = mtcars))
}

}
