% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-tests.R
\name{generate_plugin_args}
\alias{generate_plugin_args}
\alias{sink_msg}
\alias{with_mock_session}
\alias{with_mock_context}
\alias{get_s3_method}
\title{Testing utilities}
\usage{
generate_plugin_args(board, ..., mode = c("edit", "read"))

sink_msg(...)

with_mock_session(expr, session = MockShinySession$new())

with_mock_context(session, expr)

get_s3_method(generic, object)
}
\arguments{
\item{board}{A board object}

\item{...}{Forwarded to \code{\link[utils:capture.output]{utils::capture.output()}}}

\item{mode}{Edit plugins, such as \code{manage_blocks} get an additional argument
\code{update} over read plugins such as \code{preserve_board}.}

\item{expr}{Expression}

\item{session}{Shiny session object}

\item{generic}{Generic function name (passed as string)}

\item{object}{S3 Object}
}
\value{
For testing plugins, \code{generate_plugin_args()} returns objects that
mimic how plugins are called in the board server, \code{sink_msg()} is called
mainly for the side-effect of muting shiny messages (and returns them
invisibly), \code{with_mock_session()} returns \code{NULL} (invisibly) and
\code{with_mock_context()} returns the result of a call to
\code{\link[shiny:domains]{shiny::withReactiveDomain()}}. Finally, \code{get_s3_method()} returns a
class-specific implementation of the specified generic (and throws an error
if none is found).
}
\description{
Several utilities for unit testing, mainly with \code{\link[shiny:testServer]{shiny::testServer()}} that
have proven themselves useful for testing this package are exported for
re-use in other packages.
}
