% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-code.R
\name{generate_code}
\alias{generate_code}
\alias{generate_code_server}
\alias{generate_code_ui}
\title{Code generation plugin module}
\usage{
generate_code(server = generate_code_server, ui = generate_code_ui)

generate_code_server(id, board, ...)

generate_code_ui(id, board)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{board}{Reactive values object}

\item{...}{Extra arguments passed from parent scope}
}
\value{
A plugin container inheriting from \code{generate_code} is returned by
\code{generate_code()}, while the UI component (e.g. \code{generate_code_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{generate_code_server()}) is expected to return \code{NULL}.
}
\description{
All code necessary for reproducing a data analysis as set up in blockr can
be made available to the user. Several ways of providing such a script or
code snippet are conceivable and currently implemented, we have a modal
with copy-to-clipboard functionality. This is readily extensible, for example
by offering a download button, by providing this functionality as a
\code{generate_code} module.
}
