% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_coupled.R
\name{make_guess_coupled}
\alias{make_guess_coupled}
\title{Initial guesses for fitting the Baranyi-Ratkowsky model}
\usage{
make_guess_coupled(fit_data, mode = "two_steps")
}
\arguments{
\item{fit_data}{Tibble (or data.frame) of data for the fit. The shape of the data will depend on the
fitting \code{mode} (see \code{\link[=fit_coupled_growth]{fit_coupled_growth()}})}

\item{mode}{the type of model fitting approach. Either \code{two_steps} (fitted from the
values of \code{mu} and \code{lambda}) or \code{one_step} (fitted from logN)}
}
\value{
A named numeric vector of initial guesses for the model parameters
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The function uses some heuristics to provide initial guesses for the parameters
of the Baranyi-Ratkowsky model selected that can be used with \code{\link[=fit_coupled_growth]{fit_coupled_growth()}}.
}
\examples{
## Example 1: Two-steps fitting-------------------------------------------------

data(example_coupled_twosteps)

guess <- make_guess_coupled(example_coupled_twosteps)


show_guess_coupled(example_coupled_twosteps, guess)

my_fit <- fit_coupled_growth(example_coupled_twosteps, 
                             start = guess,
                             mode = "two_steps")

print(my_fit)
coef(my_fit)
summary(my_fit)
plot(my_fit)

## Example 2: One-step fitting--------------------------------------------------

data("example_coupled_onestep")

guess <- make_guess_coupled(example_coupled_onestep, mode = "one_step")

show_guess_coupled(example_coupled_onestep,
                   guess,
                   "one_step")

my_fit <- fit_coupled_growth(example_coupled_onestep,
                             start = guess,
                             mode = "one_step")

print(my_fit)
coef(my_fit)
summary(my_fit)
plot(my_fit)

 
}
