% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dvcal}
\alias{dvcal}
\title{Generalised AXPBY operation}
\usage{
dvcal(N = NULL, ALPHA = 1, X, INCX = 1L, BETA = 1, Y, INCY = 1L)
}
\arguments{
\item{N}{Optional integer giving the number of elements. Defaults to `length(X)`.}

\item{ALPHA}{Numeric scalar multiplying `X`.}

\item{X}{Double-precision vector, matrix or [`bigmemory::big.matrix`] input.}

\item{INCX}{Integer stride for traversing `X`.}

\item{BETA}{Numeric scalar multiplying `Y`.}

\item{Y}{Double-precision object updated in place.}

\item{INCY}{Integer stride for traversing `Y`.}
}
\value{
Invisibly returns the modified `Y`.
}
\description{
Computes the linear combination \eqn{Y := \alpha X + \beta Y} in place.
}
\examples{
x <- 1:5
y <- rep(2, 5)
dvcal(ALPHA = 2, X = x, BETA = -1, Y = y)
y

}
