% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_interpret.R
\name{bid_interpret}
\alias{bid_interpret}
\title{Document User Interpretation Stage in BID Framework}
\usage{
bid_interpret(
  previous_stage = NULL,
  central_question,
  data_story = NULL,
  user_personas = NULL,
  quiet = NULL
)
}
\arguments{
\item{previous_stage}{Optional tibble or list output from an earlier BID
stage function. Since Interpret is the first stage in the BID
framework, this is typically NULL but can accept previous stage output
in some iteration scenarios.}

\item{central_question}{Required. A character string representing the main
question to be answered. If NULL, will be suggested based on previous
stage information.}

\item{data_story}{A list containing elements such as \code{hook},
\code{context}, \code{tension}, \code{resolution}, and optionally
\code{audience}, \code{metrics}, and \code{visual_approach}. If NULL,
elements will be suggested based on previous stage.}

\item{user_personas}{Optional list of user personas to consider in the
design.}

\item{quiet}{Logical indicating whether to suppress informational messages.
If NULL, uses getOption("bidux.quiet", FALSE).}
}
\value{
A tibble containing the documented information for the "Interpret"
stage.
}
\description{
This function documents the interpretation of user needs, capturing the
central question and the data storytelling narrative. It represents stage 1
in the BID framework.
}
\examples{
# Recommended: use new_data_story() with flat API
interpret_result <- bid_interpret(
  central_question = "What drives the decline in user engagement?",
  data_story = new_data_story(
    hook = "Declining trend in engagement",
    context = "Previous high engagement levels",
    tension = "Unexpected drop",
    resolution = "Investigate new UI changes"
  )
)

# With user personas (using data.frame)
interpret_personas <- bid_interpret(
  central_question = "How can we improve data discovery?",
  data_story = new_data_story(
    hook = "Users are missing key insights",
    context = "Critical data is available but overlooked",
    tension = "Time-sensitive decisions are delayed",
    resolution = "Highlight key metrics more effectively",
    audience = "Data analysts and executives"
  ),
  user_personas = data.frame(
    name = c("Sara, Data Analyst", "Marcus, Executive"),
    goals = c(
      "Needs to quickly find patterns in data",
      "Wants high-level insights at a glance"
    ),
    pain_points = c(
      "Gets overwhelmed by too many visualizations",
      "Limited time to analyze detailed reports"
    ),
    technical_level = c("advanced", "beginner"),
    stringsAsFactors = FALSE
  )
)

summary(interpret_personas)

# Legacy list format still works (with deprecation warning)
\dontrun{
interpret_legacy <- bid_interpret(
  central_question = "How can we improve UX?",
  data_story = list(
    hook = "Users struggling",
    context = "Dashboard complexity",
    tension = "High abandonment rate",
    resolution = "Simplify interface"
  )
)
}

}
