% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-nb.R
\name{NB}
\alias{NB}
\title{Generate the Sampling Distribution of Sample Covariances
Using Nonparametric Bootstrapping}
\usage{
NB(object, R = 5000L, seed = NULL)
}
\arguments{
\item{object}{Object of class \code{lm}.}

\item{R}{Positive integer.
Number of bootstrap replications.}

\item{seed}{Integer.
Seed number for reproducibility.}
}
\value{
Returns an object
of class \code{nb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{lm_process}{Processed \code{lm} object.}
\item{thetahatstar}{Sampling distribution of sample covariances.}
\item{jackknife}{Jackknife estimates.}
}
}
\description{
Generate the Sampling Distribution of Sample Covariances
Using Nonparametric Bootstrapping
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaNB")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# NB -----------------------------------------------------------------------
nb <- NB(
  object,
  R = 100, # use a large value e.g., 20000L for actual research
  seed = 0508
)
nb
# The `nb` object can be passed as the first argument
# to the following functions
#   - BetaNB
#   - DeltaRSqNB
#   - DiffBetaNB
#   - PCorNB
#   - RSqNB
#   - SCorNB

}
\references{
Efron, B., & Tibshirani, R. J. (1993)
\emph{An introduction to the bootstrap}.
Chapman & Hall.
}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{PCorNB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{nb}
