% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_mrca_align_id_in_fasta.R
\name{is_mrca_align_id_in_fasta}
\alias{is_mrca_align_id_in_fasta}
\title{Determine if an MRCA prior's alignment IDs is present in the FASTA file}
\usage{
is_mrca_align_id_in_fasta(mrca_prior, fasta_filename)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{fasta_filename}{a FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.
Note that BEAST2 also supports missing data,
by using a dash (\code{-}) or question mark (\code{?})
as a sequence.}
}
\value{
TRUE if the MRCA prior's alignment IDs
  is present in the FASTA file.
  Returns FALSE otherwise
}
\description{
Determine if an MRCA prior's alignment IDs is present in the FASTA file
}
\author{
Richèl J.C. Bilderbeek
}
