% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbk.R
\name{bbk_series}
\alias{bbk_series}
\title{Fetch the Deutsche Bundesbank (BBk) series}
\source{
\url{https://www.bundesbank.de/en/statistics/time-series-databases/help-for-sdmx-web-service/web-service-interface-data}
}
\usage{
bbk_series(key)
}
\arguments{
\item{key}{(\code{character()})\cr
The series keys to query.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve a single series by its key via the Bundesbank SDMX Web Service.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
bbk_series("BBEX3.M.DKK.EUR.BB.AC.A01")
bbk_series("BBAF3.Q.F41.S121.DE.S1.W0.LE.N._X.B")
bbk_series("BBBK11.D.TTA000")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bbk_data]{bbk_data()}} for an endpoint with more options.

Other data: 
\code{\link{bbk_data}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
