% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{report_sim}
\alias{report_sim}
\title{Simulation Study of a Model}
\usage{
report_sim(
  mod_est,
  mod_sim = NULL,
  method = c("standard", "inner-outer"),
  vars_inner = NULL,
  n_sim = 100,
  point_est_fun = c("median", "mean"),
  widths = c(0.5, 0.95),
  report_type = c("short", "long", "full"),
  n_core = 1
)
}
\arguments{
\item{mod_est}{The model whose performance is being
assessed. An object of class \code{bage_mod}.}

\item{mod_sim}{The model used to generate the simulated
data. If no value is supplied, \code{mod_est} is used.}

\item{method}{Estimation method used for \code{mod_est}.
See \code{\link[=fit]{fit()}}.}

\item{vars_inner}{Variables used in inner model
with \code{"inner-outer"}estimation method.
See \code{\link[=fit]{fit()}}.}

\item{n_sim}{Number of sets of simulated data to use.
Default is 100.}

\item{point_est_fun}{Name of the function to use
to calculate point estimates. The options are \code{"mean"}
and \code{"median"}. The default is \code{"mean"}.}

\item{widths}{Widths of credible intervals.
A vector of values in the interval \verb{(0, 1]}.
Default is \code{c(0.5, 0.95)}.}

\item{report_type}{Amount of detail in return value.
Options are \code{"short"} and \code{"long"}. Default is \code{"short"}.}

\item{n_core}{Number of cores to use for parallel
processing. If \code{n_core} is \code{1} (the default),
no parallel processing is done.}
}
\value{
A named list with a tibble called \code{"components"} and a
tibble called \code{"augment"}.
}
\description{
Use simulated data to assess the performance of
an estimation model.
}
\section{Warning}{


The interface for \code{report_sim()} is still under development
and may change in future.
}

\examples{
## results random, so set seed
set.seed(0)

## make data - outcome variable (deaths here)
## needs to be present, but is not used
data <- data.frame(region = c("A", "B", "C", "D", "E"),
                   population = c(100, 200, 300, 400, 500),
                   deaths = NA)

## simulation with estimation model same as
## data-generating model
mod_est <- mod_pois(deaths ~ region,
                    data = data,
                    exposure = population) |>
  set_prior(`(Intercept)` ~ Known(0))
report_sim(mod_est = mod_est,
           n_sim = 10) ## in practice should use larger value

## simulation with estimation model different
## from data-generating model
mod_sim <- mod_est |>
  set_prior(region ~ N(s = 2))
report_sim(mod_est = mod_est,
           mod_sim = mod_sim,
           n_sim = 10)
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify binomial model
\item \code{\link[=mod_binom]{mod_binom()}} Specify binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify normal model
\item \code{\link[=set_prior]{set_prior()}} Specify non-default prior for term
\item \code{\link[=set_disp]{set_disp()}} Specify non-default prior for dispersion
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=replicate_data]{replicate_data()}} Generate replicate
data for a model
}
}
