% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_copy_image}
\alias{ec2_copy_image}
\title{Copy Image}
\usage{
ec2_copy_image(
  Name,
  SourceImageId,
  SourceRegion,
  ClientToken = NULL,
  Description = NULL,
  Encrypted = NULL,
  KmsKeyId = NULL,
  DestinationOutpostArn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Name}{Character. The name of the new AMI in the destination Region.}

\item{SourceImageId}{Character. The ID of the AMI to copy.}

\item{SourceRegion}{Character. The name of the Region that contains the AMI to copy.}

\item{ClientToken}{Character. Unique, case-sensitive identifier you provide to ensure idempotency of the request.[optional]}

\item{Description}{Character. A description for the new AMI in the destination Region.[optional]}

\item{Encrypted}{Logical. Specifies whether the destination snapshots of the copied image should be encrypted.[optional]}

\item{KmsKeyId}{Character.   The identifier of the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK)...[optional]}

\item{DestinationOutpostArn}{Character.   The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Copy Image
}
\section{Name}{

The
name of the new AMI in the destination Region.
}

\section{SourceImageId}{

The
ID of the AMI to copy.
}

\section{SourceRegion}{

The name of the Region that
contains the AMI to copy.
}

\section{ClientToken}{

Unique, case-sensitive
identifier you provide to ensure idempotency of the request. For more
information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.
}

\section{Description}{

A description for
the new AMI in the destination Region.
}

\section{Encrypted}{

Specifies
whether the destination snapshots of the copied image should be
encrypted. You can encrypt a copy of an unencrypted snapshot, but you
cannot create an unencrypted copy of an encrypted snapshot. The default
CMK for EBS is used unless you specify a non-default AWS Key Management
Service (AWS KMS) CMK using \code{KmsKeyId}. For more information, see
\href{https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{KmsKeyId}{


The identifier of the symmetric AWS Key Management Service (AWS KMS)
customer master key (CMK) to use when creating encrypted volumes. If
this parameter is not specified, your AWS managed CMK for EBS is used.
If you specify a CMK, you must also set the encrypted state to \code{true}.

You can specify a CMK using any of the following:
\itemize{
\item Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
\item Key alias. For example, alias/ExampleAlias.
\item Key ARN. For example,
arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
\item Alias ARN. For example,
arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
}

AWS authenticates the CMK asynchronously. Therefore, if you specify an
identifier that is not valid, the action can appear to complete, but
eventually fails.

The specified CMK must exist in the destination Region.

Amazon EBS does not support asymmetric CMKs.
}

\section{DestinationOutpostArn}{


The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI.
Only specify this parameter when copying an AMI from an AWS Region to an
Outpost. The AMI must be in the Region of the destination Outpost. You
cannot copy an AMI from an Outpost to a Region, from one Outpost to
another, or within the same Outpost.

For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-amis}{Copying AMIs from an AWS Region to an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

