% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc.R
\name{cc}
\alias{cc}
\title{Confidence curves for attenuated correlation coefficients.}
\usage{
cc(r, N, lower = -1, upper = 1, by = 0.001, method = "corr",
  k = NULL)
}
\arguments{
\item{r}{Numeric vector of three elements in [-1,1]. \code{r[1]} is the
correlation between the noisy measures X' and Y', \code{r[2]} is the
correlation between the noisy X' and the true X, while \code{r[3]} is
the correlation between the noisy Y' and the true Y.}

\item{N}{Numeric vector of three positive integers. \code{N[i]} is the
sample size for \code{r[i]}.}

\item{lower}{Lower bound for the curve. Defaults to -1.}

\item{upper}{Upper bound for the curve. Defaults to 1.}

\item{by}{Increment of the sequence from \code{lower} to \code{upper}.}

\item{method}{The type of confidence curve. Can be \code{"corr"},
\code{"cronbach"}, \code{"HS"} or \code{"free"}. See the details of
\code{\link{p_value}}.}

\item{k}{Numeric vector of two positive integers. \code{k[i]} is the number
of testlets for the for \code{r[i+1]}. Only needed for method
\code{"cronbach"}.}
}
\value{
An object of class \code{ccaf}.
}
\description{
Confidence curves for attenuated correlation coefficients.
}
\examples{
    r = c(0.20, sqrt(0.45), sqrt(0.55))
    N = c(100, 100, 100)
    plot(cc(r, N))
}
