% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_extract_opts.R
\name{av_grep_opts}
\alias{av_grep_opts}
\title{Extract data from Alpha Vantage returned data}
\usage{
av_grep_opts(
  indta,
  grepstring = "F,M,call",
  mindays = 3,
  startdt = Sys.Date(),
  deltarange = c(0.1, 0.55)
)
}
\arguments{
\item{indta}{A data.table as returned by \code{\link[=av_get_pf]{av_get_pf()}}}

\item{grepstring}{(default \verb{F,M,call}) Three item string to select maturities and option types from \code{indta}.  Each item is an abbreviated code for what to select.
\itemize{
\item How far out to go: \code{F} for first contract (e.g. front week), \code{B} for second/back contract, anything else for all contracts.
\item Maturity Schedule: \code{M} for monthly contracts, \code{Q} for quarterly contract, anythign else for weekly contracts.
\item Option Type: \code{call}, \code{put}, or \code{all}
}}

\item{mindays}{(default 3). Minimum number of days to expiration to be passed through from \code{startdt}}

\item{startdt}{(default \code{Sys.Date()}). Date from which expirations will be considered.}

\item{deltarange}{(default \code{c(0.1,0.55)}) Two number list with minimum and maximum absolute valued deltas to pass through.}
}
\value{
A reduced set of options obtained from \code{\link[=av_get_pf]{av_get_pf()}} using Alphavantage \code{HISTORICAL_OPTIONS} function.
}
\description{
Extract data from Alpha Vantage returned data
}
\details{
\code{\link[=av_get_pf]{av_get_pf()}} returns a large list of options.  This function helps to narrow down the list by maturity and moneyness.
}
\examples{
\dontrun{
av_get_pf("IBM","HISTORICAL_OPTIONS") |> av_grep_opts("F,M,put",mindays=2)
}

}
\seealso{
\code{\link[=av_get_pf]{av_get_pf()}}
}
