% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{vcov.feglm}
\alias{vcov.feglm}
\title{Compute covariance matrix after fitting \code{feglm}}
\usage{
\method{vcov}{feglm}(
  object,
  type = c("hessian", "outer.product", "sandwich", "clustered"),
  cluster = NULL,
  cluster.vars = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"feglm"}.}

\item{type}{the type of covariance estimate required. \code{"hessian"} refers to the inverse
of the negative expected Hessian after convergence and is the default option. 
\code{"outer.product"} is the outer-product-of-the-gradient estimator, 
\code{"sandwich"} is the sandwich estimator (sometimes also referred as robust estimator), 
and \code{"clustered"} computes a clustered covariance matrix given some cluster variables.}

\item{cluster}{a symbolic description indicating the clustering of observations.}

\item{cluster.vars}{deprecated; use \code{cluster} instead.}

\item{...}{other arguments.}
}
\value{
The function \code{\link{vcov.feglm}} returns a named matrix of covariance estimates.
}
\description{
\code{\link{vcov.feglm}} estimates the covariance matrix for the estimator of the
structural parameters from objects returned by \code{\link{feglm}}. The covariance is computed
from the Hessian, the scores, or a combination of both after convergence.
}
\details{
Multi-way clustering is done using the algorithm of Cameron, Gelbach, and Miller (2011). An 
example is provided in the vignette "Replicating an Empirical Example of International Trade".
}
\references{
Cameron, C., J. Gelbach, and D. Miller (2011). "Robust Inference With Multiway Clustering".
Journal of Business & Economic Statistics 29(2).
}
\seealso{
\code{\link{feglm}}
}
