% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_cycle_progression.R
\name{summarize_cycle_progression}
\alias{summarize_cycle_progression}
\title{Plot a cycle-specific summary graph of maintenance therapy (MT) data for single patient}
\usage{
summarize_cycle_progression(input_file_path, anc_range, unit)
}
\arguments{
\item{input_file_path}{Path to input csv file for the patient (in quotes)}

\item{anc_range}{ANC target range as per the protocol: (c(lower threshold, upper threshold)). NOTE: Ensure that units are the same as unit of ANC in the input data.}

\item{unit}{Choose either "million" or "billion".
\itemize{
\item{"million" = million cells/L (x\eqn{10^{6}} cells/L or cells/\eqn{\mu}l)}
\item{"billion" = billion cells/L (x\eqn{10^{9}} cells/L or x\eqn{10^{3}} cells/\eqn{\mu}l)}
}}
}
\value{
Plot image
}
\description{
Create summary graph with maintenance therapy data.
Weighted mean absolute neutrophil count (ANC) and dose information is calculated and plotted for each cycle.
}
\note{
\itemize{
\item{If there is only one threshold for anc_range parameter, please specify the respective value and keep the other threshold as NA. eg : c(2000, NA)}
\item{Horizontal dotted lines on the graph indicate anc_range thresholds.Red dot represents summarized overall MT data.}
}
}
\examples{
pat_data = system.file("extdata/processed_data/", "UPN_916.csv", package = "allMT")
summarize_cycle_progression(input_file_path = pat_data, anc_range = c(0.75, 1.5),
                 unit = "billion")
\donttest{
summarize_cycle_progression(input_file_path = pat_data,
                 anc_range = c(0.8, 2), unit = "billion")

# As per BFM protocol (Reference PMID - 15902295):
summarize_cycle_progression(input_file_path = pat_data,
                 anc_range = c(2, NA),
                 unit = "billion")

# As per St Jude protocol (Reference PMID - 15902295):
summarize_cycle_progression(input_file_path = pat_data,
                 anc_range = c(0.8, 2),
                 unit = "billion")

}

}
\seealso{
\code{\link[=plot_progression]{plot_progression()}}
}
