% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_stop_doses.R
\name{assess_stop_doses}
\alias{assess_stop_doses}
\title{Analyze physicians' compliance to dosing guidelines: STOP DOSE}
\usage{
assess_stop_doses(
  input_files_path,
  anc_threshold = NA,
  plt_threshold = NA,
  hb_threshold = NA
)
}
\arguments{
\item{input_files_path}{path to a file or a folder with MT csv files (in quotes).}

\item{anc_threshold}{Absolute neutrophil count (ANC) value threshold below which doses should be stopped. NOTE: Ensure that the threshold value is represented with same unit as of the input ANC data.}

\item{plt_threshold}{Platelet (PLT) value threshold below which doses should be stopped. NOTE: Ensure that the threshold value is represented with same unit as of the input PLT data.}

\item{hb_threshold}{Hemoglobin (HB) value threshold below which doses should be stopped. NOTE: Ensure that the threshold value is represented with same unit as of the input Hb data.}
}
\value{
Returns a list with (1) the 'STOP DOSE' analysis for each patient as listed below,
(2) analysis summary as dataframe (3) analysis summary as HTML table in viewer.
\enumerate{
\item{Pat ID}
\item{Number of decisions where the physician stopped dose (a)}
\item{Number of times blood counts did not support dose suspension (b)}
\item{Discordance (\%) = (\eqn{(b/a)*100)}}
}
}
\description{
Evaluate number of times blood counts did not support physicians' STOP DOSE decision
}
\note{
\enumerate{
\item{Atleast one of the threshold parameters (anc_threshold, plt_threshold, hb_threshold) must be provided to carry out analysis. Missing threshold parameter will not be considered.}
\item{If the function is used for cohort analysis then a and b will be represented as median and interquartile range (IQR) (25\%-75\%). The median and IQR is rounded off to upper integer value if decimal value is greater or equal to 0.5, else to lower integer value Example 1.4->1 and 3.75->4}
\item{User may save the result as a list, if required, to analyze each patient separately - use 1st element of list. Please refer to examples from \link[allMT]{assess_anemia}}
}
}
\examples{
pat_data <- system.file("extdata/processed_data/", "UPN_915.csv", package = "allMT")
assess_stop_doses(input_files_path = pat_data,
                  anc_threshold = 0.5, plt_threshold = 50, hb_threshold = 7)

\donttest{
assess_stop_doses(input_files_path = pat_data,
                  anc_threshold = 0.5)

cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
assess_stop_doses(input_files_path = cohort_path,
                  anc_threshold = 0.5,plt_threshold = 50, hb_threshold = 7)
}
}
\seealso{
\code{\link[=assess_reduced_doses]{assess_reduced_doses()}}, \code{\link[=assess_increased_doses]{assess_increased_doses()}}
}
