% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{add_suffix_to_vars}
\alias{add_suffix_to_vars}
\title{Add a Suffix to Variables in a List of Expressions}
\usage{
add_suffix_to_vars(order, vars, suffix)
}
\arguments{
\item{order}{List of expressions

\describe{
\item{Permitted values}{list of variables or \verb{desc(<variable>)} function calls created by
\code{exprs()}, e.g., \code{exprs(ADT, desc(AVAL))}}
\item{Default value}{none}
}}

\item{vars}{Variables to change

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{none}
}}

\item{suffix}{Suffix

\describe{
\item{Permitted values}{a character scalar, i.e., a character vector of length one}
\item{Default value}{none}
}}
}
\value{
The list of expression where for each element the suffix (\code{suffix}) is
added to every symbol specified for \code{vars}
}
\description{
Add a suffix to variables in a list of expressions
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(rlang)

add_suffix_to_vars(exprs(ADT, desc(AVAL), AVALC), vars = exprs(AVAL), suffix = ".join")
}
\seealso{
Helpers for working with Quosures:
\code{\link{expr_c}()},
\code{\link{replace_symbol_in_expr}()},
\code{\link{replace_values_by_names}()}
}
\concept{quo}
\keyword{quo}
