% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRE.R
\name{plotRE}
\alias{plotRE}
\title{Visualizing the random effect estimates using ggplot2}
\usage{
plotRE(
  obj,
  levelRE = c("all", "first", "second"),
  colour = "black",
  plot = TRUE
)
}
\arguments{
\item{obj}{an object of type \code{\link{hierCredibility}}, \code{\link{hierCredGLM}} or \code{\link{hierCredTweedie}}}

\item{levelRE}{indicates which hierarchical level has to be used. \code{"all"} plots both levels in the hierarchy,
\code{"first"} the first level in the hierarchy and \code{"second"} the second level.}

\item{colour}{colour for \code{\link[ggplot2]{geom_point}}}

\item{plot}{logical indicating if the \code{\link[ggplot2]{ggplot}} objects have to be plotted.}
}
\value{
a list with \code{\link[ggplot2]{ggplot}} objects.
}
\description{
Using this function, you can create plots of the random effect estimates from fitted random effects models. To make
the plots, we rely on the \code{\link[ggplot2]{ggplot2}} package.
}
\examples{
\donttest{
fitHGLM <- hierCredGLM(Y ~ area + gender + (1 | VehicleType / VehicleBody), dataCar, weights = w)
plotRE(fitHGLM)
}
}
