% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs.R
\name{score_samples}
\alias{score_samples}
\title{Computes a score from three objective functions.}
\usage{
score_samples(
  var_samples,
  df,
  num_samples,
  quantile_ind,
  corrs,
  min_val,
  vario_dep,
  vario_params,
  weights
)
}
\arguments{
\item{var_samples}{Subsampled indices to test}

\item{df}{A dataframe with three columns of data}

\item{num_samples}{The number of subsamples}

\item{quantile_ind}{The quantile of the independent variable in \code{df}}

\item{corrs}{A vector of three correlations of the two variables in \code{df}}

\item{min_val}{The minimum time or distance between two points in \code{df}}

\item{vario_dep}{The computed Variogram of the data}

\item{vario_params}{The parameters to set for computing a Variogram}

\item{weights}{A vector of three weights for each objective function}
}
\value{
Returns the summed score of the weighted objective functions
}
\description{
Computes a score from the sum of three objective functions multiplied by
their respective weights. The score is used to determine the best set of
indices subsampled by the acLHS algorithm, where lower is better.
}
