% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{run_app}
\alias{run_app}
\title{Run the Shiny app}
\usage{
run_app(datapath = NULL, ...)
}
\arguments{
\item{datapath}{Full path to a single \code{.csv} or \code{.rds} data file.}

\item{...}{Arguments passed to \code{shiny::runApp()}}
}
\value{
No return value, called for side effects to launch the Shiny application.
}
\description{
Run the Shiny app
}
\details{
If a \code{datapath} is provided, the app will attempt to automatically load the
specified dataset on startup. This is achieved by setting an internal option
(\code{options(aNCA.datapath = datapath)}), which the app then reads.
\strong{This pre-loaded dataset can be overwritten; if a new file is uploaded using
the widget within the app, it will replace the initial data for the current session.}

If \code{datapath} is \code{NULL} (default), the app will launch without pre-loading any
data, and a file must be uploaded manually within the app.
}
\examples{
\donttest{
  # Show the packaged example path (safe non-interactive snippet)
  adnca_path <- system.file("shiny/data/Dummy_data.csv", package = "aNCA")
  adnca_path

  # To actually launch the app, run interactively:
  if (interactive()) {
    run_app(datapath = adnca_path)
  }
}
}
