% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WallomicsData-package.R
\docType{data}
\name{Transcriptomics_Stems_CW}
\alias{Transcriptomics_Stems_CW}
\title{Transcriptomics Stems Cell Wall}
\format{
A data frame with 30 rows and 414 variables.
}
\source{
\doi{10.3390/cells9102249}
}
\usage{
data("Transcriptomics_Stems_CW")
}
\description{
A dataset containing the transcripts encoding Cell Wall Proteins (CWPs) sorted
from the 22 570 transcripts (see \link{Transcriptomics_Stems}) obtained by RNA-seq performed,
according to the standard Illumina protocols,
on floral stems of five \emph{A. thaliana} genotypes at two growth temperatures.
See \link{Ecotype} and \link{Temperature} for more information.
}
\examples{
# Load the dataset
data("Transcriptomics_Stems_CW")

# Look at data frame dimensions
dim(Transcriptomics_Stems_CW)

# Look at the first rows and columns
head(Transcriptomics_Stems_CW[,c(1:10)])

# Create a colors' vector
colors <- c(rep("#A6CEE3",3), rep("#1F78B4",3), rep("#B2DF8A",3), rep("#33A02C",3),
            rep("#FB9A99",3), rep("#E31A1C",3), rep("#FDBF6F",3), rep("#FF7F00",3),
            rep("#CAB2D6",3), rep("#6A3D9A",3))

# PCA on transcriptomics
res.pca <- prcomp(Transcriptomics_Stems_CW, center = TRUE, scale. = TRUE)
plot(res.pca$x[,"PC1"], res.pca$x[,"PC2"], pch = 19, xlab = "PC1", ylab = "PC2", lwd = 5,
     main = "Individuals' plot (1 x 2) - PCA on Stems Cell Wall Transcriptomics",
     col = colors)
text(res.pca$x[,"PC1"], res.pca$x[,"PC2"], labels = row.names(res.pca$x), cex = 0.8, pos = 3)

}
\keyword{datasets}
